<?php
use App\Models\Package;

$packages = Package::where('status', 'active')->get();
?>
<!DOCTYPE html>
<html>
<head>  
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
  <title>Home_B2GOLD</title> 

  <link rel="stylesheet" href="/mbtech/layui.css"> 
  <link rel="stylesheet" href="/mbtech/common.css?t=1.2"> 
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
  <link rel="stylesheet" href="/mbtech/swiper-bundle.min.css"> 

  <style>
    .swiper-slide {
      width: 80%;
      background: linear-gradient(180deg, #E6FFEF 0%, #FFFFFF 100%);
      border-radius: 12px 12px;
      margin: auto;
    }

    .swiper-slide img {
      width: 100%;
      height: 250px;
      display: block;
      border-radius: 8px;
    }

    .index_body {
      background: #ffffff;
      background-image: url(/mbtech/bg1.png);
      background-size: 100% 318px;
      background-repeat: no-repeat;
    }

    .index_invite_btn {
      display: block;
      background: linear-gradient(180deg, #3AB4FF 0%, #0672B5 100%);
      border-radius: 100px;
      width: 188px;
      height: 36px;
      font-family: Arial, Arial;
      font-weight: 700;
      font-size: 18px;
      color: #FFFFFF;
      line-height: 36px;
      text-align: center;
      margin: 10px auto 0 auto; /* Reduced top margin to close gap */
    }

    .product_menu {
      background: #FFFFFF;
      border-radius: 8px;
      margin: 0 15px;
      padding: 15px 0 0 0;
    }

    .product_menu .name {
      font-family: Arial, Arial;
      font-weight: 700;
      font-size: 16px;
      color: #888888;
      line-height: 18px;
      margin-bottom: 5px;
    }

    .product_menu .product_menu_nav_active .name {
      color: #145ECC;
    }

    .product_menu .describe {
      font-family: Arial, Arial;
      font-weight: 400;
      font-size: 12px;
      color: #999999;
      line-height: 14px;
      margin-bottom: 5px;
    }

    .product_menu .bottom_order {
      width: 30px;
      height: 6px;
      background: linear-gradient(101deg, #155BCD 2%, #01A9B1 100%);
      border-radius: 100px;
      margin: auto;
    }

    .product_menu .product_menu_nav .bottom_order {
      display: none;
    }

    .product_menu .product_menu_nav_active .bottom_order {
      display: block;
    }

    .swiper {
      margin-bottom: 0 !important;
      padding-bottom: 0 !important;
    }

    .swiper-container {
      margin-bottom: 0 !important;
      padding-bottom: 0 !important;
    }
    .product_list {
      display: none;
    }
    .product_list.active {
      display: block;
    }
  </style>
</head>

<body class="index_body"> 
  <div class="index_header" style="padding: 0px; padding-top: 40px; background:none;"> 
    <div class="index_logo" style="padding: 0 15px"> 
      <div> 
        <!-- <img src="/public/site/img/index/logo.png" style="height: 32px;width: auto;"> --> 
      </div> 
      <a href="#" class="notice position" style="line-height: 32px;"> 
        <img src="/mbtech/notice.png" style="height: 24px;width: 24px;border-radius: 50%">
      </a> 
    </div> 

    <!--<div class="swiper" style="margin-top: 30px"> 
      <div class="swiper-container mySwiper"> 
        <div class="swiper-wrapper">
          <div class="swiper-slide"> 
            <img src="/mbtech/banner1.jpg"> 
          </div>
          <div class="swiper-slide"> 
            <img src="/mbtech/banner1.jpg"> 
          </div>
          <div class="swiper-slide"> 
            <img src="/mbtech/banner1.jpg"> 
          </div> 
        </div> -->
        <div class="swiper" style="margin-top: 30px"> 
    <div class="swiper-container mySwiper swiper-initialized swiper-horizontal swiper-free-mode swiper-android swiper-backface-hidden"> 
     <div class="swiper-wrapper" id="swiper-wrapper-5fc5d15c18267377" aria-live="polite" style="transition-duration: 0ms; transition-delay: 0ms; transform: translate3d(-262px, 0px, 0px);"> 
      <div class="swiper-slide swiper-slide-prev" role="group" aria-label="1 / 3" style="margin-right: 10px;"> 
       <img src="/mbtech/banner1.jpg" style="border-radius:8px"> 
      </div> 
      <div class="swiper-slide swiper-slide-active" role="group" aria-label="2 / 3" style="margin-right: 10px;"> 
       <img src="/mbtech/banner1.jpg" style="border-radius:8px"> 
      </div> 
      <div class="swiper-slide swiper-slide-next" role="group" aria-label="3 / 3" style="margin-right: 10px;"> 
       <img src="/mbtech/banner1.jpg" style="border-radius:8px"> 
      </div> 
     </div> 
        <!-- Add Pagination if needed -->
        <div class="swiper-pagination"></div> 
      </div> 
    </div> 
  </div>

  <a href="/lottery" class="index_invite_btn">
    <img src="/mbtech/lottery.png" style="width:20px;height:20px; background:#fff;border-radius:10px;"> 
    Fortune Roulette
  </a> 

  <div class="index_main" style="background:#F4F4F4;"> 
    <div class="layui-row" style="margin-top: 20px; background: #FFFFFf"> 
      <div class="layui-col-md3 layui-col-xs3"> 
        <a href="/user/recharge" class="menu_item"> 
          <img src="/mbtech/recharge.png" style="width: 60px;height: 60px;"> 
          <div><p class="menu_title">Recharge</p></div> 
        </a> 
      </div> 
      <div class="layui-col-md3 layui-col-xs3"> 
        <a href="/withdraw" class="menu_item"> 
          <img src="/mbtech/withdrawal.png" style="width: 60px;height: 60px;"> 
          <div><p class="menu_title">Withdrawal</p></div> 
        </a> 
      </div> 
      <div class="layui-col-md3 layui-col-xs3"> 
        <a href="/help" class="menu_item"> 
          <img src="/mbtech/service.png?v=2" style="width: 50px;height: 50px;margin:5px 0"> 
          <div><p class="menu_title">Service</p></div> 
        </a> 
      </div> 
      <div class="layui-col-md3 layui-col-xs3"> 
        <a href="/vip" class="menu_item"> 
          <img src="/mbtech/vip (1).png" style="width: 60px;height: 60px;"> 
          <div><p class="menu_title">Vip</p></div> 
        </a> 
      </div> 
    </div>
 <!-- </div>-->
  <div class="product_menu flex_space" style="margin-top:15px"> 
    <div class="product_menu_nav product_menu_nav_active" style="text-align: center;width: 30%;" data-type="1" data-image="fixed" onclick="setActiveTab(1)">
     <p class="name">Stable</p> 
     <!--<p class="describe">recommendation</p>--> 
     <p class="bottom_order"></p> 
    </div> 
    <div class="product_menu_nav" style="text-align: center;width: 30%" data-type="2" data-image="welfare" onclick="setActiveTab(2)">
     <p class="name">VIP</p> 
     <!--<p class="describe">Fast returns</p>--> 
     <p class="bottom_order"></p> 
    </div> 
    <div class="product_menu_nav" style="text-align: center;width: 30%" data-type="3" data-image="activity" onclick="setActiveTab(3)">
     <p class="name">Activity</p> 
     <!--<p class="describe">Super Affordable</p>--> 
     <p class="bottom_order"></p> 
    </div> 
   </div> 
   <div style="padding: 15px"> 
    <div class="product_type_1 product_list active"> 
    @foreach ($packages as $package)
    @if ($package->category == 'fixed')
        @php
            $isSoldOut = $package->is_sold_out == 1;
            $isResale = $package->is_resale == 1;
            $buyLabel = $isSoldOut ? 'Sold Out' : ($isResale ? 'Resale' : 'Buy');
            $buyStyle = $isSoldOut ? 'background:#ccc;color:#666;cursor:not-allowed;' : ($isResale ? 'background:#ffc107;color:#000;' : '');
        @endphp

        <a @if(!$isSoldOut) onclick="window.location.href='{{ route('vip.details', $package->id) }}'" @endif 
           class="product_card position"
           style="cursor: {{ $isSoldOut ? 'not-allowed' : 'pointer' }};"> 

            <div style="padding: 10px"> 
                <div class="product_image" style="height: 150px;width: 100%"> 
                    <img src="{{ asset($package->photo) }}" style="height: 150px;width: 100%;border-radius: 8px;"> 
                </div> 

                <div class="product_title_card"> 
                    <div class="flex_space"> 
                        <div>
                            {{ $package->name }}
                            <img src="/public/site/img/vip/lv0.png" class="lv"> 
                        </div> 
                        <div class="buy" style="{{ $buyStyle }}">
                            {{ $buyLabel }}
                        </div> 
                    </div> 
                </div> 

                <div class="product_content position"> 
                    <div class="product_title flex_left"> 
                        <div class="product_info"> 
                            <div class="product_item flex_space"> 
                                <p class="label">Price</p> 
                                <p class="value position"> {{ price($package->price) }} </p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Days</p> 
                                <p class="value"> {{ $package->validity }} days</p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Daily Income</p> 
                                <p class="value"> {{ price($package->commission_with_avg_amount / $package->validity) }} </p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Total Income</p> 
                                <p class="value"> {{ price($package->commission_with_avg_amount) }} </p> 
                            </div> 
                        </div> 
                    </div> 
                </div> 
            </div> 
        </a> 
    @endif
@endforeach


    
     <div class="none_data  hide"> 
      <img class="none_image" src="/public/site/img/order/none_order.png"> 
      <p class="none_text"> No items available for invest </p> 
     </div> 
    </div> 
    <div class="product_type_2 product_list hide"> 
    @foreach ($packages as $package)
      @if ($package->category == 'welfare')
      @php
            $isSoldOut = $package->is_sold_out == 1;
            $isResale = $package->is_resale == 1;
            $buyLabel = $isSoldOut ? 'Sold Out' : ($isResale ? 'Resale' : 'Buy');
            $buyStyle = $isSoldOut ? 'background:#ccc;color:#666;cursor:not-allowed;' : ($isResale ? 'background:#ffc107;color:#000;' : '');
        @endphp

        <a @if(!$isSoldOut) onclick="window.location.href='{{ route('vip.details', $package->id) }}'" @endif 
           class="product_card position"
           style="cursor: {{ $isSoldOut ? 'not-allowed' : 'pointer' }};"> 

            <div style="padding: 10px"> 
                <div class="product_image" style="height: 150px;width: 100%"> 
                    <img src="{{ asset($package->photo) }}" style="height: 150px;width: 100%;border-radius: 8px;"> 
                </div> 

                <div class="product_title_card"> 
                    <div class="flex_space"> 
                        <div>
                            {{ $package->name }}
                            <img src="/public/site/img/vip/lv0.png" class="lv"> 
                        </div> 
                        <div class="buy" style="{{ $buyStyle }}">
                            {{ $buyLabel }}
                        </div> 
                    </div> 
                </div> 

                <div class="product_content position"> 
                    <div class="product_title flex_left"> 
                        <div class="product_info"> 
                            <div class="product_item flex_space"> 
                                <p class="label">Price</p> 
                                <p class="value position"> {{ price($package->price) }} </p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Days</p> 
                                <p class="value"> {{ $package->validity }} days</p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Daily Income</p> 
                                <p class="value"> {{ price($package->commission_with_avg_amount / $package->validity) }} </p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Total Income</p> 
                                <p class="value"> {{ price($package->commission_with_avg_amount) }} </p> 
                            </div> 
                        </div> 
                    </div> 
                </div> 
            </div> 
        </a> 
    @endif
    @endforeach
     <div class="none_data  hide"> 
      <img class="none_image" src="/public/site/img/order/none_order.png"> 
      <p class="none_text"> No items available for invest </p> 
     </div> 
    </div> 
    <div class="product_type_3 product_list show"> 
    @foreach ($packages as $package)
      @if ($package->category == 'activity')
      @php
            $isSoldOut = $package->is_sold_out == 1;
            $isResale = $package->is_resale == 1;
            $buyLabel = $isSoldOut ? 'Sold Out' : ($isResale ? 'Resale' : 'Buy');
            $buyStyle = $isSoldOut ? 'background:#ccc;color:#666;cursor:not-allowed;' : ($isResale ? 'background:#ffc107;color:#000;' : '');
        @endphp

        <a @if(!$isSoldOut) onclick="window.location.href='{{ route('vip.details', $package->id) }}'" @endif 
           class="product_card position"
           style="cursor: {{ $isSoldOut ? 'not-allowed' : 'pointer' }};"> 

            <div style="padding: 10px"> 
                <div class="product_image" style="height: 150px;width: 100%"> 
                    <img src="{{ asset($package->photo) }}" style="height: 150px;width: 100%;border-radius: 8px;"> 
                </div> 

                <div class="product_title_card"> 
                    <div class="flex_space"> 
                        <div>
                            {{ $package->name }}
                            <img src="/public/site/img/vip/lv0.png" class="lv"> 
                        </div> 
                        <div class="buy" style="{{ $buyStyle }}">
                            {{ $buyLabel }}
                        </div> 
                    </div> 
                </div> 

                <div class="product_content position"> 
                    <div class="product_title flex_left"> 
                        <div class="product_info"> 
                            <div class="product_item flex_space"> 
                                <p class="label">Price</p> 
                                <p class="value position"> {{ price($package->price) }} </p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Days</p> 
                                <p class="value"> {{ $package->validity }} days</p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Daily Income</p> 
                                <p class="value"> {{ price($package->commission_with_avg_amount / $package->validity) }} </p> 
                            </div> 
                            <div class="product_item flex_space"> 
                                <p class="label">Total Income</p> 
                                <p class="value"> {{ price($package->commission_with_avg_amount) }} </p> 
                            </div> 
                        </div> 
                    </div> 
                </div> 
            </div> 
        </a> 
    @endif
    @endforeach
    </div>
  <div class="layui-layer-shade" id="layui-layer-shade1" times="1" style="z-index: 19891014; background-color: rgb(0, 0, 0); opacity: 0.3;"></div>
  <div class="layui-layer layui-layer-page  layer-anim layer-anim-00" id="layui-layer1" type="page" times="1" showtime="0" contype="string" style="z-index: 19891015; width: 90%; height: auto; position: fixed; top: 185.5px; left: 18px;">
   <div class="layui-layer-content" style="height: 298px;">
    <div class="dialog">
     <div class="dialog_contents">
      <div class="logo">
       <img src="/mbtech/telegram.png" style="">
      </div>
      <div class="title" style="margin:15px 0;text-align: center;font-weight: 700;font-size: 20px;">
       Official Information Release
      </div>
      <div class="text" style="text-align: center;font-weight:400;font-size: 14px;color: #818393;line-height: 24px;">
       Follow our official telegram channel to get the latest news and welfare information
      </div>
     </div>
     <div class="btn_group">
      <div class="cancel">
       Cancel
      </div>
      <a href="https://" class="confirm">Follow Now</a>
     </div>
    </div>
   </div>
   <div class="layui-layer-setwin"></div>
   <span class="layui-layer-resize"></span>
  </div>
  <div class="layui-layer-move" id="layui-layer-move"></div>
     
    <div class="footer_menu"> 
    <div class="content"> 
     <a href="/" class="item active"> <img src="/mbtech/home_active.png"> <p>Home</p> </a> 
     <a href="/blog" class="item "> <img src="/mbtech/blog.png"> <p>Blog</p> </a> 
     <a href="/invitation" class="item "> <img src="/mbtech/mb/invest.png"> <p>Team</p> </a> 
     <a href="/tasks" class="item "> <img src="/mbtech/tasks.png"> <p>Tasks</p> </a> 
     <a href="/my" class="item "> <img src="/mbtech/my.png"> <p>My</p> </a> 
    </div> 
   </div> 
   
   <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    @include('alert-message')
<img style="position: fixed;
    display: none;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 100%;" src="{{asset('public/loading.gif')}}" class="loading" alt="">
<script>
    function checkin(){
        //document.querySelector('.loading').style.display = 'block';
        window.location.href='{{route('user.checkin')}}'
    }
  document.addEventListener("DOMContentLoaded", function () {
    // Hide the initial popup by default
    document.getElementById("layui-layer1").style.display = "none";
    document.getElementById("layui-layer-shade1").style.display = "none";

    // Show the first popup after a delay (like 2 seconds)
    setTimeout(() => {
      document.getElementById("layui-layer1").style.display = "block";
      document.getElementById("layui-layer-shade1").style.display = "block";
    }, 2000);

    // Handle cancel button click for the first popup
    const cancelBtn = document.querySelector(".cancel");
    if (cancelBtn) {
      cancelBtn.addEventListener("click", () => {
        closePopup("layui-layer1", "layui-layer-shade1");
      });
    }

    // Handle the background shade click to close the first popup
    const shade1 = document.getElementById("layui-layer-shade1");
    if (shade1) {
      shade1.addEventListener("click", () => {
        closePopup("layui-layer1", "layui-layer-shade1");
      });
    }

    // Show a second popup with a download button after 8 seconds
    setTimeout(() => {
      const downloadPopup = `
        <div class="layui-layer layui-layer-page layer-anim layer-anim-00" id="download-popup" type="page" times="1" style="z-index: 19891016; width: 90%; height: auto; position: fixed; top: 185.5px; left: 18px;">
          <div class="layui-layer-content" style="height: 298px;">
            <div class="dialog">
              <div class="dialog_contents">
                <div class="title" style="margin:15px 0;text-align: center;font-weight: 700;font-size: 20px;">
                  Download Your File
                </div>
                <div class="text" style="text-align: center;font-weight:400;font-size: 14px;color: #818393;line-height: 24px;">
                  Click below to start downloading.
                </div>
              </div>
              <div class="btn_group">
                <a href="/path-to-your-file.zip" class="confirm">Download Now</a>
              </div>
            </div>
          </div>
          <div class="layui-layer-setwin"></div>
        </div>
        <div class="layui-layer-shade" id="download-shade" style="z-index: 19891014; background-color: rgb(0, 0, 0); opacity: 0.3;"></div>
      `;
      
      // Append the second popup to the body
      document.body.insertAdjacentHTML('beforeend', downloadPopup);

      // Show the second popup
      document.getElementById("download-popup").style.display = "block";
      document.getElementById("download-shade").style.display = "block";

      // Handle cancel button click for the second popup
      const cancelDownloadBtn = document.querySelector("#download-popup .cancel");
      if (cancelDownloadBtn) {
        cancelDownloadBtn.addEventListener("click", () => {
          closePopup("download-popup", "download-shade");
        });
      }

      // Handle the background shade click to close the second popup
      const shade2 = document.getElementById("download-shade");
      if (shade2) {
        shade2.addEventListener("click", () => {
          closePopup("download-popup", "download-shade");
        });
      }
    }, 8000); // Show download popup after 4 seconds

    // Function to close the popup and shade
    function closePopup(popupId, shadeId) {
      document.getElementById(popupId).style.display = "none";
      document.getElementById(shadeId).style.display = "none";
    }
});


</script>

  <!-- ✅ Swiper JS -->
  <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
  <script>
    var swiper = new Swiper('.swiper-container', {
      loop: true,
      autoplay: {
        delay: 3000,
        disableOnInteraction: false,
      },
      pagination: {
        el: '.swiper-pagination',
        clickable: true,
      },
    });
    
  document.addEventListener('DOMContentLoaded', function () {
    setActiveTab(1); // Set default tab to Stable on load
  });

    function setActiveTab(type) {
      document.querySelectorAll('.product_menu_nav').forEach(nav => nav.classList.remove('product_menu_nav_active'));
      document.querySelector('.product_menu_nav[data-type="' + type + '"]').classList.add('product_menu_nav_active');

      document.querySelectorAll('.product_list').forEach(list => list.classList.remove('active'));
      document.querySelector('.product_type_' + type).classList.add('active');
    }
  </script>
</body>